/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.storagedrawers.client.model.ModelContextSupplier;
import com.jaquadro.minecraft.storagedrawers.client.model.ParentModel;
import com.jaquadro.minecraft.storagedrawers.client.model.context.ModelContext;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.ModelDecorator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_777;

@Environment(value=EnvType.CLIENT)
public class PlatformDecoratedModel<C extends ModelContext>
extends ParentModel
implements FabricBakedModel {
    private final ModelDecorator<C> decorator;
    private final ModelContextSupplier<C> contextSupplier;
    private static Map<class_1087, Mesh> meshCache = new HashMap<class_1087, Mesh>();
    private static RenderMaterial cutoutMat;
    private static RenderMaterial transMat;

    public PlatformDecoratedModel(class_1087 parent, ModelDecorator<C> decorator, ModelContextSupplier<C> contextSupplier) {
        super(parent);
        this.decorator = decorator;
        this.contextSupplier = contextSupplier;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        Supplier<ModelContext> supplier = () -> this.contextSupplier.makeContext(stack);
        if (this.decorator.shouldRenderBase(supplier, stack)) {
            this.parent.emitItemQuads(stack, randomSupplier, context);
        }
        class_5819 randomSource = randomSupplier.get();
        BiConsumer<class_1087, class_1921> emitModel = (model, renderType) -> {
            if (model != null) {
                if (renderType == class_1921.method_23583()) {
                    class_1792 patt2837$temp = stack.method_7909();
                    if (patt2837$temp instanceof class_1747) {
                        class_1747 bi = (class_1747)patt2837$temp;
                        Mesh mesh = this.getMesh((class_1087)model, bi.method_7711().method_9564(), randomSource, (class_1921)renderType);
                        mesh.outputTo(context.getEmitter());
                    }
                } else {
                    model.emitItemQuads(stack, randomSupplier, context);
                }
            }
        };
        try {
            this.decorator.emitItemQuads(supplier, emitModel, stack);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        Object renderData;
        if (state == null) {
            this.parent.emitBlockQuads(blockView, state, pos, randomSupplier, context);
            return;
        }
        class_1920 fabricView = blockView;
        if (fabricView == null) {
            return;
        }
        class_5819 randomSource = randomSupplier.get();
        Supplier<ModelContext> supplier = () -> this.lambda$emitBlockQuads$2(state, randomSource, renderData = fabricView.getBlockEntityRenderData(pos));
        if (this.decorator.shouldRenderBase(supplier)) {
            this.parent.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        }
        BiConsumer<class_1087, class_1921> emitModel = (model, renderType) -> {
            if (model != null) {
                if (renderType == class_1921.method_23583()) {
                    Mesh mesh = this.getMesh((class_1087)model, state, randomSource, (class_1921)renderType);
                    mesh.outputTo(context.getEmitter());
                } else {
                    model.emitBlockQuads(blockView, state, pos, randomSupplier, context);
                }
            }
        };
        try {
            this.decorator.emitQuads(supplier, emitModel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Mesh getMesh(class_1087 model, class_2680 state, class_5819 randomSource, class_1921 renderType) {
        if (meshCache.containsKey(model)) {
            return meshCache.get(model);
        }
        Mesh mesh = this.buildMesh(model, state, randomSource, renderType);
        meshCache.put(model, mesh);
        return mesh;
    }

    private Mesh buildMesh(class_1087 model, class_2680 state, class_5819 randomSource, class_1921 renderType) {
        Renderer render = RendererAccess.INSTANCE.getRenderer();
        RenderMaterial mat = null;
        if (renderType == class_1921.method_23579()) {
            if (cutoutMat == null) {
                cutoutMat = render.materialFinder().blendMode(BlendMode.CUTOUT_MIPPED).find();
            }
            mat = cutoutMat;
        } else if (renderType == class_1921.method_23583()) {
            if (transMat == null) {
                transMat = render.materialFinder().blendMode(BlendMode.TRANSLUCENT).find();
            }
            mat = transMat;
        }
        if (mat == null) {
            return null;
        }
        MeshBuilder builder = render.meshBuilder();
        QuadEmitter quadEmit = builder.getEmitter();
        for (class_2350 d : class_2350.values()) {
            for (class_777 quad : model.method_4707(state, d, randomSource)) {
                quadEmit.fromVanilla(quad, mat, d).emit();
            }
        }
        for (class_777 quad : model.method_4707(state, null, randomSource)) {
            quadEmit.fromVanilla(quad, mat, null).emit();
        }
        return builder.build();
    }

    private /* synthetic */ ModelContext lambda$emitBlockQuads$2(class_2680 state, class_5819 randomSource, Object renderData) {
        return this.contextSupplier.makeContext(state, null, randomSource, renderData, null);
    }
}

